<?php
require 'koneksi.php';
session_start();

$error = '';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $email = $_POST['email'];
    $password = $_POST['password'];

    // Mencegah SQL Injection sederhana
    $email = $conn->real_escape_string($email);

    $sql = "SELECT id, username, password FROM users WHERE email = '$email'";
    $result = $conn->query($sql);

    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        // Verifikasi password (gunakan password_hash() saat register)
        if (password_verify($password, $row['password'])) {
            $_SESSION['user_id'] = $row['id'];
            $_SESSION['username'] = $row['username'];
            header("Location: dashboard.php");
            exit();
        } else {
            $error = "Password salah!";
        }
    } else {
        $error = "Email tidak ditemukan!";
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Agency Dashboard</title>
    <!-- Menggunakan CDN Tailwind untuk styling cepat tanpa Node.js -->
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-900 text-white flex items-center justify-center min-h-screen">
    <div class="w-full max-w-md p-8 space-y-6 bg-gray-800 rounded-lg shadow-lg">
        <h2 class="text-2xl font-bold text-center">Login User</h2>
        <?php if($error): ?>
            <div class="bg-red-500 text-white p-3 rounded text-sm text-center">
                <?php echo $error; ?>
            </div>
        <?php endif; ?>
        <form method="POST" action="">
            <div>
                <label class="block mb-1 text-sm">Email</label>
                <input type="email" name="email" required class="w-full px-4 py-2 bg-gray-700 border border-gray-600 rounded focus:outline-none focus:border-blue-500">
            </div>
            <div>
                <label class="block mb-1 text-sm">Password</label>
                <input type="password" name="password" required class="w-full px-4 py-2 bg-gray-700 border border-gray-600 rounded focus:outline-none focus:border-blue-500">
            </div>
            <button type="submit" class="w-full py-2 font-bold text-white bg-blue-600 rounded hover:bg-blue-700 transition">
                Masuk
            </button>
        </form>
        <p class="text-sm text-center text-gray-400">
            Belum punya akun? <a href="register.php" class="text-blue-400 hover:underline">Daftar disini</a>
        </p>
    </div>
</body>
</html>
