-- Buat Database
CREATE DATABASE IF NOT EXISTS agency_website_db;
USE agency_website_db;

-- Tabel Users
CREATE TABLE IF NOT EXISTS users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) NOT NULL UNIQUE,
    email VARCHAR(100) NOT NULL UNIQUE,
    password VARCHAR(255) NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Tabel Websites (Layanan Sewa)
CREATE TABLE IF NOT EXISTS websites (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT,
    domain_name VARCHAR(100) NOT NULL,
    plan_type ENUM('Starter', 'Business', 'E-Commerce') DEFAULT 'Starter',
    status ENUM('active', 'expired', 'suspended') DEFAULT 'active',
    expiry_date DATE NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
);

-- Dummy Data User (Password: 123456)
INSERT INTO users (username, email, password) VALUES 
('john_doe', 'john@example.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi');

-- Dummy Data Website
INSERT INTO websites (user_id, domain_name, plan_type, status, expiry_date) VALUES 
(1, 'tokosepatu.com', 'E-Commerce', 'active', DATE_ADD(CURDATE(), INTERVAL 30 DAY)),
(1, 'lenzaphoto.id', 'Starter', 'expired', DATE_SUB(CURDATE(), INTERVAL 2 DAY));
