<?php
require 'koneksi.php';
require 'auth_check.php';

check_login();

$user_id = $_SESSION['user_id'];

// Logika Pengecekan Expired Real-time (Optional jika Cron Job belum jalan)
$update_sql = "UPDATE websites SET status = 'suspended' WHERE expiry_date < CURDATE() AND status = 'active' AND user_id = $user_id";
$conn->query($update_sql);

// Ambil Data Website User
$sql = "SELECT * FROM websites WHERE user_id = $user_id";
$result = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard User</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-900 text-gray-100 min-h-screen">

    <!-- Navbar -->
    <nav class="border-b border-gray-700 bg-gray-800/50 backdrop-blur">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between h-16">
                <div class="flex items-center">
                    <span class="text-xl font-bold text-white">LUMINA Agency</span>
                </div>
                <div class="flex items-center gap-4">
                    <span>Halo, <strong><?php echo htmlspecialchars($_SESSION['username']); ?></strong></span>
                    <a href="logout.php" class="px-3 py-1 text-sm text-red-400 border border-red-400 rounded hover:bg-red-400 hover:text-white transition">Logout</a>
                </div>
            </div>
        </div>
    </nav>

    <main class="max-w-7xl mx-auto py-10 px-4 sm:px-6 lg:px-8">
        <h1 class="text-3xl font-bold mb-6">Website Saya</h1>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <?php if ($result->num_rows > 0): ?>
                <?php while($row = $result->fetch_assoc()): ?>
                    <?php 
                        $is_expired = ($row['status'] == 'expired' || $row['status'] == 'suspended'); 
                        $status_color = $is_expired ? 'text-red-500' : 'text-green-500';
                        $card_border = $is_expired ? 'border-red-500/50 bg-red-900/10' : 'border-gray-700 bg-gray-800';
                    ?>
                    
                    <div class="border rounded-lg p-6 <?php echo $card_border; ?> shadow-lg transition hover:shadow-xl">
                        <div class="flex justify-between items-start mb-4">
                            <div>
                                <h3 class="text-xl font-semibold text-white"><?php echo htmlspecialchars($row['domain_name']); ?></h3>
                                <p class="text-sm text-gray-400">Paket: <?php echo htmlspecialchars($row['plan_type']); ?></p>
                            </div>
                            <span class="px-2 py-1 text-xs font-bold rounded <?php echo $is_expired ? 'bg-red-500/20 text-red-400' : 'bg-green-500/20 text-green-400'; ?>">
                                <?php echo strtoupper($row['status']); ?>
                            </span>
                        </div>

                        <div class="space-y-2 mb-6">
                            <div class="flex justify-between text-sm">
                                <span class="text-gray-400">Status Web:</span>
                                <span class="font-medium <?php echo $status_color; ?>">
                                    <?php echo $is_expired ? 'Non-Aktif (Suspended)' : 'Online / Aktif'; ?>
                                </span>
                            </div>
                            <div class="flex justify-between text-sm">
                                <span class="text-gray-400">Berakhir pada:</span>
                                <span class="font-medium text-white">
                                    <?php echo date('d F Y', strtotime($row['expiry_date'])); ?>
                                </span>
                            </div>
                        </div>

                        <?php if($is_expired): ?>
                            <div class="bg-red-500/10 border border-red-500/20 p-3 rounded mb-4">
                                <p class="text-xs text-red-300">
                                    ⚠️ Website Anda telah dinonaktifkan karena masa sewa habis. Silahkan perpanjang untuk mengaktifkan kembali.
                                </p>
                            </div>
                            <a href="payment.php?id=<?php echo $row['id']; ?>" class="block w-full text-center py-2 bg-red-600 hover:bg-red-700 text-white rounded font-semibold transition">
                                Perpanjang Sekarang
                            </a>
                        <?php else: ?>
                            <button class="block w-full py-2 bg-gray-700 text-gray-300 rounded cursor-not-allowed" disabled>
                                Website Aktif
                            </button>
                        <?php endif; ?>
                    </div>

                <?php endwhile; ?>
            <?php else: ?>
                <p class="text-gray-400">Anda belum menyewa website apapun.</p>
            <?php endif; ?>
        </div>
    </main>

</body>
</html>
