"use client"

import Link from "next/link"
import { Button } from "@/components/ui/button"
import { motion } from "framer-motion"
import { Menu, X } from "lucide-react"
import { useState } from "react"

export function Navbar() {
  const [isOpen, setIsOpen] = useState(false)

  return (
    <nav className="fixed top-0 left-0 right-0 z-50 bg-background/80 backdrop-blur-md border-b border-border/40">
      <div className="container mx-auto px-6 h-16 flex items-center justify-between">
        <Link href="/" className="text-xl font-bold tracking-tight">
          LUMINA
        </Link>

        {/* Desktop Menu */}
        <div className="hidden md:flex items-center gap-8 text-sm font-medium">
          <Link href="#services" className="text-muted-foreground hover:text-foreground transition-colors">
            Services
          </Link>
          <Link href="#rental" className="text-muted-foreground hover:text-foreground transition-colors">
            Rental Website
          </Link>
          <Link href="#portfolio" className="text-muted-foreground hover:text-foreground transition-colors">
            Portfolio
          </Link>
          <div className="flex items-center gap-4 ml-4">
            <Link href="/login">
              <Button variant="ghost" size="sm">
                Log in
              </Button>
            </Link>
            <Link href="/register">
              <Button size="sm">Get Started</Button>
            </Link>
          </div>
        </div>

        {/* Mobile Toggle */}
        <button className="md:hidden" onClick={() => setIsOpen(!isOpen)}>
          {isOpen ? <X /> : <Menu />}
        </button>
      </div>

      {/* Mobile Menu */}
      {isOpen && (
        <motion.div
          initial={{ opacity: 0, y: -20 }}
          animate={{ opacity: 1, y: 0 }}
          className="md:hidden absolute top-16 left-0 right-0 bg-background border-b border-border p-6 flex flex-col gap-4"
        >
          <Link href="#services" onClick={() => setIsOpen(false)}>
            Services
          </Link>
          <Link href="#rental" onClick={() => setIsOpen(false)}>
            Rental Website
          </Link>
          <Link href="#portfolio" onClick={() => setIsOpen(false)}>
            Portfolio
          </Link>
          <hr className="border-border" />
          <Link href="/login" onClick={() => setIsOpen(false)}>
            Log in
          </Link>
          <Link href="/register" onClick={() => setIsOpen(false)}>
            Get Started
          </Link>
        </motion.div>
      )}
    </nav>
  )
}
