"use client"

import { Navbar } from "@/components/navbar"
import { Button } from "@/components/ui/button"
import { Card, CardContent, CardHeader, CardTitle, CardDescription, CardFooter } from "@/components/ui/card"
import { Badge } from "@/components/ui/badge"
import { motion } from "framer-motion"
import { ArrowRight, Globe, Smartphone, Clock, ShieldCheck, Zap, Layers, Users, BarChart } from "lucide-react"
import Link from "next/link"

const fadeInUp = {
  initial: { opacity: 0, y: 20 },
  animate: { opacity: 1, y: 0 },
  transition: { duration: 0.5 },
}

const stagger = {
  animate: {
    transition: {
      staggerChildren: 0.1,
    },
  },
}

export default function Home() {
  return (
    <div className="min-h-screen bg-background text-foreground overflow-x-hidden">
      <Navbar />

      {/* Hero Section */}
      <section className="relative pt-32 pb-20 md:pt-48 md:pb-32 px-6">
        <div className="container mx-auto max-w-5xl text-center space-y-8">
          <motion.div initial={{ opacity: 0, y: 20 }} animate={{ opacity: 1, y: 0 }} transition={{ duration: 0.6 }}>
            <Badge
              variant="outline"
              className="mb-4 py-1 px-4 text-sm border-primary/20 bg-primary/5 text-primary rounded-full"
            >
              #1 Digital Agency Solution
            </Badge>
            <h1 className="text-5xl md:text-7xl font-bold tracking-tight leading-tight mb-6">
              Transforming Ideas into <br className="hidden md:block" />
              <span className="text-gradient bg-clip-text text-transparent bg-gradient-to-r from-white to-gray-500">
                Digital Reality
              </span>
            </h1>
            <p className="text-xl text-muted-foreground max-w-2xl mx-auto mb-10 leading-relaxed">
              Kami menyediakan jasa pembuatan website & aplikasi profesional serta layanan sewa website bulanan dengan
              sistem manajemen otomatis.
            </p>
            <div className="flex flex-col sm:flex-row items-center justify-center gap-4">
              <Link href="/login">
                <Button size="lg" className="h-12 px-8 text-base rounded-full">
                  Mulai Sekarang <ArrowRight className="ml-2 h-4 w-4" />
                </Button>
              </Link>
              <Link href="#services">
                <Button size="lg" variant="secondary" className="h-12 px-8 text-base rounded-full">
                  Lihat Layanan
                </Button>
              </Link>
            </div>
          </motion.div>
        </div>

        {/* Abstract Background Elements */}
        <div className="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 -z-10 w-[800px] h-[800px] bg-primary/5 rounded-full blur-3xl opacity-50 pointer-events-none" />
      </section>

      {/* Infinite Marquee - Client Logos */}
      <section className="py-10 border-y border-border/40 bg-card/30 overflow-hidden">
        <div className="container mx-auto px-6 mb-6 text-center">
          <p className="text-sm font-medium text-muted-foreground uppercase tracking-widest">
            Dipercaya oleh Perusahaan Modern
          </p>
        </div>
        <div className="relative flex overflow-x-hidden">
          <div className="animate-marquee whitespace-nowrap flex gap-16 items-center">
            {/* Doubled specifically for seamless loop */}
            {[...Array(2)].map((_, i) => (
              <div
                key={i}
                className="flex gap-16 items-center min-w-full justify-around opacity-50 grayscale hover:grayscale-0 transition-all duration-500"
              >
                <span className="text-2xl font-bold flex items-center gap-2">
                  <Layers className="h-8 w-8" /> TechCorp
                </span>
                <span className="text-2xl font-bold flex items-center gap-2">
                  <Zap className="h-8 w-8" /> FastStream
                </span>
                <span className="text-2xl font-bold flex items-center gap-2">
                  <Globe className="h-8 w-8" /> GlobalNet
                </span>
                <span className="text-2xl font-bold flex items-center gap-2">
                  <Users className="h-8 w-8" /> CommunityHub
                </span>
                <span className="text-2xl font-bold flex items-center gap-2">
                  <BarChart className="h-8 w-8" /> DataFlow
                </span>
                <span className="text-2xl font-bold flex items-center gap-2">
                  <Layers className="h-8 w-8" /> TechCorp
                </span>
                <span className="text-2xl font-bold flex items-center gap-2">
                  <Zap className="h-8 w-8" /> FastStream
                </span>
                <span className="text-2xl font-bold flex items-center gap-2">
                  <Globe className="h-8 w-8" /> GlobalNet
                </span>
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* Services Section */}
      <section id="services" className="py-24 bg-secondary/5">
        <div className="container mx-auto px-6">
          <div className="flex flex-col md:flex-row justify-between items-end mb-16 gap-6">
            <div>
              <h2 className="text-3xl md:text-4xl font-bold mb-4">Layanan Kami</h2>
              <p className="text-muted-foreground max-w-md">
                Solusi lengkap untuk kebutuhan digital bisnis Anda, mulai dari pengembangan hingga maintenance.
              </p>
            </div>
            <Link href="/register">
              <Button variant="outline" className="rounded-full bg-transparent">
                Konsultasi Gratis
              </Button>
            </Link>
          </div>

          <motion.div
            variants={stagger}
            initial="initial"
            whileInView="animate"
            viewport={{ once: true }}
            className="grid grid-cols-1 md:grid-cols-3 gap-6"
          >
            <ServiceCard
              icon={<Globe className="h-8 w-8 text-primary" />}
              title="Web Development"
              description="Website responsif, cepat, dan SEO friendly menggunakan teknologi terbaru seperti Next.js dan PHP Laravel."
            />
            <ServiceCard
              icon={<Smartphone className="h-8 w-8 text-primary" />}
              title="App Development"
              description="Aplikasi mobile Android & iOS native atau cross-platform yang powerful dan user friendly."
            />
            <ServiceCard
              icon={<Clock className="h-8 w-8 text-primary" />}
              title="Sewa Website"
              description="Solusi hemat biaya dengan sistem sewa bulanan. Website aktif instan, maintenance gratis."
            />
          </motion.div>
        </div>
      </section>

      {/* Rental System Feature */}
      <section id="rental" className="py-24 px-6 border-y border-border/50">
        <div className="container mx-auto">
          <div className="grid grid-cols-1 lg:grid-cols-2 gap-16 items-center">
            <motion.div
              initial={{ opacity: 0, x: -30 }}
              whileInView={{ opacity: 1, x: 0 }}
              transition={{ duration: 0.6 }}
              viewport={{ once: true }}
            >
              <Badge className="mb-4 rounded-full">Fitur Unggulan</Badge>
              <h2 className="text-4xl font-bold mb-6">Sistem Sewa Website Otomatis</h2>
              <div className="space-y-8">
                <FeatureItem
                  title="Aktivasi Instan"
                  desc="Website langsung online setelah pembayaran pertama dikonfirmasi sistem otomatis kami."
                />
                <FeatureItem
                  title="Dashboard User"
                  desc="Pantau status sewa, perpanjang masa aktif, dan kelola konten melalui dashboard user yang intuitif."
                />
                <FeatureItem
                  title="Auto-Suspend System"
                  desc="Jika masa sewa habis, website otomatis nonaktif sementara. Data tetap aman selama masa tenggang 30 hari."
                />
              </div>
              <div className="mt-8">
                <Link href="/dashboard">
                  <Button variant="default" size="lg" className="rounded-full">
                    Coba Dashboard Demo
                  </Button>
                </Link>
              </div>
            </motion.div>

            <motion.div
              initial={{ opacity: 0, scale: 0.95 }}
              whileInView={{ opacity: 1, scale: 1 }}
              transition={{ duration: 0.6 }}
              viewport={{ once: true }}
              className="relative bg-card rounded-2xl border border-border p-2 shadow-2xl"
            >
              <div className="absolute inset-0 bg-primary/10 blur-3xl -z-10 rounded-full" />
              {/* Using a div to simulate the image to avoid external dependency issues if image fails, but kept src for structure */}
              <div className="rounded-xl overflow-hidden bg-muted aspect-video relative group">
                <div className="absolute inset-0 bg-gradient-to-tr from-background/80 to-transparent z-10" />
                <img
                  src="/dashboard-ui-dark.jpg"
                  alt="Dashboard Preview"
                  className="w-full h-full object-cover transition-transform duration-700 group-hover:scale-105"
                />

                {/* Floating UI Elements for realism */}
                <div className="absolute top-6 left-6 right-6 z-20">
                  <div className="flex gap-4 mb-4">
                    <div className="h-20 w-1/3 bg-background/50 backdrop-blur-md rounded-lg border border-white/10 p-3">
                      <div className="h-2 w-12 bg-primary/50 rounded mb-2"></div>
                      <div className="h-6 w-16 bg-white/80 rounded"></div>
                    </div>
                    <div className="h-20 w-1/3 bg-background/50 backdrop-blur-md rounded-lg border border-white/10 p-3">
                      <div className="h-2 w-12 bg-green-500/50 rounded mb-2"></div>
                      <div className="h-6 w-8 bg-white/80 rounded"></div>
                    </div>
                    <div className="h-20 w-1/3 bg-background/50 backdrop-blur-md rounded-lg border border-white/10 p-3">
                      <div className="h-2 w-12 bg-red-500/50 rounded mb-2"></div>
                      <div className="h-6 w-8 bg-white/80 rounded"></div>
                    </div>
                  </div>
                  <div className="h-40 w-full bg-background/50 backdrop-blur-md rounded-lg border border-white/10"></div>
                </div>
              </div>

              <div className="absolute -bottom-6 -right-6 bg-card border border-border p-4 rounded-xl shadow-xl max-w-xs z-30">
                <div className="flex items-center gap-3 mb-2">
                  <div className="h-3 w-3 rounded-full bg-green-500 animate-pulse shadow-[0_0_10px_rgba(34,197,94,0.5)]" />
                  <span className="text-sm font-medium">Status: Active</span>
                </div>
                <p className="text-xs text-muted-foreground">Expires in 28 days. Auto-renewal enabled.</p>
              </div>
            </motion.div>
          </div>
        </div>
      </section>

      {/* Pricing */}
      <section id="pricing" className="py-24 px-6 bg-secondary/10">
        <div className="container mx-auto text-center max-w-4xl">
          <Badge variant="secondary" className="mb-4 rounded-full">
            Pricing Plans
          </Badge>
          <h2 className="text-3xl md:text-4xl font-bold mb-4">Paket Sewa Website</h2>
          <p className="text-muted-foreground mb-16 max-w-2xl mx-auto">
            Pilih paket yang sesuai dengan kebutuhan bisnis Anda. Upgrade kapan saja dengan mudah melalui dashboard.
          </p>

          <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
            <PricingCard
              title="Starter"
              price="Rp 150rb"
              period="/bulan"
              features={["Landing Page", "Domain .com (Tahun pertama)", "SSL Security", "Standard Support"]}
            />
            <PricingCard
              title="Business"
              price="Rp 350rb"
              period="/bulan"
              isPopular
              features={[
                "5 Halaman Web",
                "Domain .com & Email",
                "SEO Basic",
                "Priority Support",
                "Analytics Dashboard",
              ]}
            />
            <PricingCard
              title="E-Commerce"
              price="Rp 750rb"
              period="/bulan"
              features={["Online Store", "Payment Gateway", "Inventory System", "24/7 Support", "Marketing Tools"]}
            />
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="py-24 px-6 relative overflow-hidden">
        <div className="absolute inset-0 bg-primary z-0 opacity-5" />
        <div className="container mx-auto relative z-10 text-center">
          <h2 className="text-3xl md:text-4xl font-bold mb-6">Siap Mengembangkan Bisnis Digital Anda?</h2>
          <p className="text-muted-foreground max-w-2xl mx-auto mb-10 text-lg">
            Konsultasikan kebutuhan website dan aplikasi Anda dengan tim ahli kami sekarang.
          </p>
          <div className="flex flex-col sm:flex-row justify-center gap-4">
            <Link href="/register">
              <Button
                size="lg"
                className="h-14 px-8 text-lg rounded-full shadow-xl shadow-primary/20 hover:shadow-primary/40 transition-all"
              >
                Buat Akun Sekarang
              </Button>
            </Link>
            <Link href="#">
              <Button
                size="lg"
                variant="outline"
                className="h-14 px-8 text-lg rounded-full bg-background/50 backdrop-blur-sm"
              >
                Hubungi via WhatsApp
              </Button>
            </Link>
          </div>
        </div>
      </section>

      {/* Footer */}
      <footer className="py-12 px-6 border-t border-border bg-background">
        <div className="container mx-auto">
          <div className="grid grid-cols-1 md:grid-cols-4 gap-12 mb-12">
            <div className="md:col-span-1">
              <Link href="/" className="text-xl font-bold tracking-tight mb-4 block">
                LUMINA
              </Link>
              <p className="text-sm text-muted-foreground leading-relaxed">
                Partner digital terpercaya untuk transformasi bisnis Anda. Melayani pembuatan website, aplikasi, dan
                sistem sewa website profesional.
              </p>
            </div>
            <div>
              <h4 className="font-semibold mb-4">Layanan</h4>
              <ul className="space-y-2 text-sm text-muted-foreground">
                <li>
                  <Link href="#" className="hover:text-primary transition-colors">
                    Web Development
                  </Link>
                </li>
                <li>
                  <Link href="#" className="hover:text-primary transition-colors">
                    App Development
                  </Link>
                </li>
                <li>
                  <Link href="#" className="hover:text-primary transition-colors">
                    Website Rental
                  </Link>
                </li>
                <li>
                  <Link href="#" className="hover:text-primary transition-colors">
                    UI/UX Design
                  </Link>
                </li>
              </ul>
            </div>
            <div>
              <h4 className="font-semibold mb-4">Perusahaan</h4>
              <ul className="space-y-2 text-sm text-muted-foreground">
                <li>
                  <Link href="#" className="hover:text-primary transition-colors">
                    Tentang Kami
                  </Link>
                </li>
                <li>
                  <Link href="#" className="hover:text-primary transition-colors">
                    Portfolio
                  </Link>
                </li>
                <li>
                  <Link href="#" className="hover:text-primary transition-colors">
                    Karir
                  </Link>
                </li>
                <li>
                  <Link href="#" className="hover:text-primary transition-colors">
                    Blog
                  </Link>
                </li>
              </ul>
            </div>
            <div>
              <h4 className="font-semibold mb-4">Legal</h4>
              <ul className="space-y-2 text-sm text-muted-foreground">
                <li>
                  <Link href="#" className="hover:text-primary transition-colors">
                    Privacy Policy
                  </Link>
                </li>
                <li>
                  <Link href="#" className="hover:text-primary transition-colors">
                    Terms of Service
                  </Link>
                </li>
              </ul>
            </div>
          </div>
          <div className="border-t border-border pt-8 flex flex-col md:flex-row justify-between items-center gap-4 text-sm text-muted-foreground">
            <p>&copy; 2025 Lumina Agency. All rights reserved.</p>
            <div className="flex gap-4">{/* Social icons would go here */}</div>
          </div>
        </div>
      </footer>
    </div>
  )
}

function ServiceCard({ icon, title, description }: { icon: any; title: string; description: string }) {
  return (
    <motion.div variants={fadeInUp}>
      <Card className="h-full bg-card hover:bg-secondary/40 transition-colors border-border/50 hover:border-primary/50 group">
        <CardHeader>
          <div className="mb-4 w-12 h-12 rounded-xl bg-primary/10 flex items-center justify-center group-hover:scale-110 transition-transform duration-300">
            {icon}
          </div>
          <CardTitle>{title}</CardTitle>
        </CardHeader>
        <CardContent>
          <CardDescription className="text-base leading-relaxed">{description}</CardDescription>
        </CardContent>
      </Card>
    </motion.div>
  )
}

function FeatureItem({ title, desc }: { title: string; desc: string }) {
  return (
    <div className="flex gap-4">
      <div className="mt-1 flex-shrink-0 h-8 w-8 rounded-full bg-primary/10 text-primary flex items-center justify-center border border-primary/20">
        <ShieldCheck className="h-4 w-4" />
      </div>
      <div>
        <h3 className="font-semibold mb-1 text-lg">{title}</h3>
        <p className="text-sm text-muted-foreground leading-relaxed">{desc}</p>
      </div>
    </div>
  )
}

function PricingCard({
  title,
  price,
  period,
  features,
  isPopular,
}: { title: string; price: string; period: string; features: string[]; isPopular?: boolean }) {
  return (
    <Card
      className={`relative flex flex-col transition-all duration-300 hover:translate-y-[-5px] ${isPopular ? "border-primary/50 shadow-2xl shadow-primary/10 bg-card" : "border-border/50 bg-card/50"}`}
    >
      {isPopular && (
        <div className="absolute -top-3 left-1/2 -translate-x-1/2 bg-primary text-primary-foreground text-xs font-bold px-3 py-1 rounded-full shadow-lg">
          MOST POPULAR
        </div>
      )}
      <CardHeader>
        <CardTitle className="text-lg font-medium text-muted-foreground">{title}</CardTitle>
        <div className="mt-2 flex items-baseline justify-center gap-1">
          <span className="text-4xl font-bold">{price}</span>
          <span className="text-sm text-muted-foreground">{period}</span>
        </div>
      </CardHeader>
      <CardContent className="flex-1">
        <ul className="space-y-4 text-sm">
          {features.map((f, i) => (
            <li key={i} className="flex items-start gap-3 text-left">
              <div className="mt-0.5 rounded-full bg-primary/20 p-0.5">
                <Zap className="h-3 w-3 text-primary shrink-0" />
              </div>
              <span className="text-muted-foreground">{f}</span>
            </li>
          ))}
        </ul>
      </CardContent>
      <CardFooter>
        <Link href="/register" className="w-full">
          <Button className="w-full rounded-full" variant={isPopular ? "default" : "outline"}>
            Pilih Paket
          </Button>
        </Link>
      </CardFooter>
    </Card>
  )
}
