"use client"

import { CardFooter } from "@/components/ui/card"

import { Button } from "@/components/ui/button"
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card"
import { Badge } from "@/components/ui/badge"
import { Tabs, TabsContent, TabsList, TabsTrigger } from "@/components/ui/tabs"
import { Globe, Clock, CreditCard, LayoutDashboard, Settings, LogOut, AlertCircle, CheckCircle2 } from "lucide-react"
import Link from "next/link"

// Mock Data for Rental Websites
const myWebsites = [
  {
    id: 1,
    name: "Toko Sepatu Online",
    domain: "tokosepatu.com",
    plan: "E-Commerce",
    status: "active",
    expiryDate: "2025-06-25",
    daysLeft: 30,
    thumbnail: "/shoe-store.jpg",
  },
  {
    id: 2,
    name: "Portfolio Fotografi",
    domain: "lenzaphoto.id",
    plan: "Starter",
    status: "expired",
    expiryDate: "2025-05-20",
    daysLeft: -4,
    thumbnail: "/photography-still-life.png",
  },
]

export default function Dashboard() {
  return (
    <div className="min-h-screen flex bg-background">
      {/* Sidebar */}
      <aside className="w-64 border-r border-border bg-card/30 hidden md:flex flex-col">
        <div className="p-6">
          <Link href="/" className="text-xl font-bold tracking-tight">
            LUMINA
          </Link>
        </div>
        <nav className="flex-1 px-4 space-y-2">
          <Button variant="secondary" className="w-full justify-start gap-2">
            <LayoutDashboard className="h-4 w-4" /> Overview
          </Button>
          <Button variant="ghost" className="w-full justify-start gap-2">
            <Globe className="h-4 w-4" /> My Websites
          </Button>
          <Button variant="ghost" className="w-full justify-start gap-2">
            <CreditCard className="h-4 w-4" /> Billing
          </Button>
          <Button variant="ghost" className="w-full justify-start gap-2">
            <Settings className="h-4 w-4" /> Settings
          </Button>
        </nav>
        <div className="p-4 border-t border-border">
          <Link href="/">
            <Button
              variant="ghost"
              className="w-full justify-start gap-2 text-destructive hover:text-destructive hover:bg-destructive/10"
            >
              <LogOut className="h-4 w-4" /> Sign Out
            </Button>
          </Link>
        </div>
      </aside>

      {/* Main Content */}
      <main className="flex-1 p-6 md:p-10 overflow-y-auto">
        <header className="flex justify-between items-center mb-8">
          <div>
            <h1 className="text-3xl font-bold">Dashboard</h1>
            <p className="text-muted-foreground">Manage your websites and subscription status.</p>
          </div>
          <div className="flex items-center gap-4">
            <div className="h-10 w-10 rounded-full bg-primary/20 flex items-center justify-center font-bold text-primary">
              JD
            </div>
          </div>
        </header>

        <Tabs defaultValue="overview" className="space-y-6">
          <TabsList>
            <TabsTrigger value="overview">Overview</TabsTrigger>
            <TabsTrigger value="active">Active Sites</TabsTrigger>
            <TabsTrigger value="billing">History</TabsTrigger>
          </TabsList>

          <TabsContent value="overview" className="space-y-6">
            {/* Stats */}
            <div className="grid grid-cols-1 md:grid-cols-3 gap-6">
              <Card>
                <CardHeader className="flex flex-row items-center justify-between pb-2">
                  <CardTitle className="text-sm font-medium">Total Websites</CardTitle>
                  <Globe className="h-4 w-4 text-muted-foreground" />
                </CardHeader>
                <CardContent>
                  <div className="text-2xl font-bold">2</div>
                </CardContent>
              </Card>
              <Card>
                <CardHeader className="flex flex-row items-center justify-between pb-2">
                  <CardTitle className="text-sm font-medium">Active Subscriptions</CardTitle>
                  <CheckCircle2 className="h-4 w-4 text-green-500" />
                </CardHeader>
                <CardContent>
                  <div className="text-2xl font-bold">1</div>
                </CardContent>
              </Card>
              <Card>
                <CardHeader className="flex flex-row items-center justify-between pb-2">
                  <CardTitle className="text-sm font-medium">Pending Renewals</CardTitle>
                  <AlertCircle className="h-4 w-4 text-destructive" />
                </CardHeader>
                <CardContent>
                  <div className="text-2xl font-bold">1</div>
                </CardContent>
              </Card>
            </div>

            {/* Websites List */}
            <h2 className="text-xl font-semibold mt-8 mb-4">Your Websites</h2>
            <div className="grid grid-cols-1 lg:grid-cols-2 gap-6">
              {myWebsites.map((site) => (
                <WebsiteCard key={site.id} site={site} />
              ))}
            </div>
          </TabsContent>
        </Tabs>
      </main>
    </div>
  )
}

function WebsiteCard({ site }: { site: any }) {
  const isExpired = site.status === "expired"

  return (
    <Card
      className={`overflow-hidden transition-all ${isExpired ? "border-destructive/50 bg-destructive/5" : "hover:border-primary/50"}`}
    >
      <div className="h-32 bg-secondary/50 relative">
        <div className="absolute inset-0 flex items-center justify-center text-muted-foreground">
          {/* Placeholder for site preview */}
          <Globe className="h-12 w-12 opacity-20" />
        </div>
        <div className="absolute top-4 right-4">
          <Badge variant={isExpired ? "destructive" : "default"}>{isExpired ? "Suspended" : "Active"}</Badge>
        </div>
      </div>
      <CardHeader>
        <div className="flex justify-between items-start">
          <div>
            <CardTitle>{site.name}</CardTitle>
            <CardDescription>{site.domain}</CardDescription>
          </div>
          <Badge variant="outline">{site.plan}</Badge>
        </div>
      </CardHeader>
      <CardContent>
        <div className="space-y-4">
          <div className="flex items-center justify-between text-sm">
            <span className="text-muted-foreground">Status:</span>
            <span className={`font-medium ${isExpired ? "text-destructive" : "text-green-500"}`}>
              {isExpired ? "Website Deactivated" : "Online"}
            </span>
          </div>

          <div className="flex items-center justify-between text-sm">
            <span className="text-muted-foreground">Expires:</span>
            <span className="font-medium flex items-center gap-2">
              <Clock className="h-3 w-3" />
              {site.expiryDate}
            </span>
          </div>

          {isExpired && (
            <div className="bg-destructive/10 p-3 rounded-md border border-destructive/20 flex gap-3">
              <AlertCircle className="h-5 w-5 text-destructive shrink-0" />
              <p className="text-xs text-destructive-foreground">
                Masa sewa Anda telah habis. Website dinonaktifkan sementara. Perpanjang sekarang untuk mengaktifkan
                kembali.
              </p>
            </div>
          )}
        </div>
      </CardContent>
      <CardFooter className="bg-secondary/20 pt-4">
        <Button className="w-full" variant={isExpired ? "default" : "outline"}>
          {isExpired ? "Perpanjang Sekarang (Bayar)" : "Manage Website"}
        </Button>
      </CardFooter>
    </Card>
  )
}
